-- =============================================
-- New Hictoric.Notes field 
-- March 2012 
-- =============================================

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'Notes' AND object_id = OBJECT_ID(N'Historic'))
BEGIN
	ALTER TABLE Historic ADD Notes varchar(max) NULL
END
GO



IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Sp_updaterespondenthistory]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[Sp_updaterespondenthistory]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO
/****** Object:  StoredProcedure [dbo].[Sp_updaterespondenthistory]    Script Date: 03/07/2012 15:33:16 ******/
CREATE PROCEDURE [dbo].[Sp_updaterespondenthistory]
                @ProjectId           INT,
                @CollectMode         INT,
                @HisRespondent       VARCHAR(10),
                @HisCallNumber       INT,
                @HisInterviewer      VARCHAR(10),
                @HisResult           VARCHAR(2),
                @HisCallDate         DATETIME,
                @HisTimeSlot         INT,
                @HisCallDuration     INT,
                @HisDataType         INT,
                @HisStartQuestion    VARCHAR(10),
                @HisEndQuestion      VARCHAR(10),
                @HisMonitoring       BIT,
                @HisDialerLine       INT,
                @HisWait             INT,
                @HisPause            INT,
                @HisFileReference    VARCHAR(120),
                @HisPreviousCallDate DATETIME,
                @HisLifeState        VARCHAR(2),
                @HisPhone            VARCHAR(20) = NULL,
                @DialingMode         INT = NULL, -- Null => Do not change
                @LevelChanged        BIT = 0,
                @Notes               NVARCHAR(MAX) = NULL
AS
  UPDATE historic
  SET    hisrespondent = @HisRespondent,
         hiscallnumber = @HisCallNumber,
         hisinterviewer = @HisInterviewer,
         hisresult = @HisResult,
         hiscalldate = @HisCallDate,
         histimeslot = @HisTimeSlot,
         hiscallduration = @HisCallDuration,
         hisdatatype = @HisDataType,
         hisstartquestion = @HisStartQuestion,
         hisendquestion = @HisEndQuestion,
         hismonitoring = @HisMonitoring,
         hisdialerline = @HisDialerLine,
         hiswait = @HisWait,
         hispause = @HisPause,
         hisfilereference = @HisFileReference,
         hispreviouscalldate = @HisPreviousCallDate,
         hislifestate = @HisLifeState,
         projectid = @projectId,
         collectmode = @collectMode,
         HisPhone = @HisPhone,
         DialingMode = IsNull(@DialingMode,DialingMode),
         LevelChanged = @LevelChanged,
         Notes = @Notes
  WHERE  hisrespondent = @HisRespondent
         AND hiscallnumber = @HisCallNumber
  IF @@ROWCOUNT = 0
    BEGIN
      INSERT INTO historic
                 (hisrespondent,
                  hiscallnumber,
                  hisinterviewer,
                  hisresult,
                  hiscalldate,
                  histimeslot,
                  hiscallduration,
                  hisdatatype,
                  hisstartquestion,
                  hisendquestion,
                  hismonitoring,
                  hisdialerline,
                  hiswait,
                  hispause,
                  hisfilereference,
                  hispreviouscalldate,
                  hislifestate,
                  projectid,
                  collectmode,
                  HisPhone,
                  DialingMode,
                  LevelChanged,
                  Notes)
      VALUES     (@HisRespondent,
                  @HisCallNumber,
                  @HisInterviewer,
                  @HisResult,
                  @HisCallDate,
                  @HisTimeSlot,
                  @HisCallDuration,
                  @HisDataType,
                  @HisStartQuestion,
                  @HisEndQuestion,
                  @HisMonitoring,
                  @HisDialerLine,
                  @HisWait,
                  @HisPause,
                  @HisFileReference,
                  @HisPreviousCallDate,
                  @HisLifeState,
                  @projectId,
                  @collectMode, 
                  @HisPhone,
                  IsNull(@DialingMode,0),
                  @LevelChanged,
                  @Notes)
    END
GO
